# Iyzico 3D Secure Payment Integration

Bu proje, Iyzico ödeme sistemini kullanarak 3D Secure ödemelerini işlemek için PHP tabanlı bir API sağlar.

## Kurulum

1. Composer ile bağımlılıkları yükleyin:
```bash
composer install
```

2. `.env.example` dosyasını `.env` olarak kopyalayın ve Iyzico API bilgilerinizi girin:
```bash
cp .env.example .env
```

3. `.env` dosyasındaki değerleri güncelleyin:
```
IYZICO_API_KEY=your-api-key-here
IYZICO_SECRET_KEY=your-secret-key-here
IYZICO_BASE_URL=https://sandbox-api.iyzipay.com
IYZICO_CALLBACK_URL=https://yourdomain.com/api/callback.php
IYZICO_SUCCESS_URL=https://yourdomain.com/pages/success.php
IYZICO_FAILURE_URL=https://yourdomain.com/pages/failure.php
```

## API Kullanımı

### 1. Ödeme Başlatma

**Endpoint:** `POST /api/payment.php`

**İstek Formatı:**
```json
{
    "conversation_id": "unique-conversation-id",
    "price": "100.00",
    "paid_price": "100.00",
    "basket_id": "basket-123",
    "card": {
        "holder_name": "John Doe",
        "number": "5528790000000008",
        "expire_month": "12",
        "expire_year": "2030",
        "cvc": "123"
    },
    "buyer": {
        "id": "buyer-123",
        "name": "John",
        "surname": "Doe",
        "gsm_number": "+905350000000",
        "email": "email@email.com",
        "identity_number": "74300864791",
        "last_login_date": "2023-03-05 12:43:35",
        "registration_date": "2013-04-21 15:12:09",
        "registration_address": "Address",
        "ip": "85.34.78.112",
        "city": "Istanbul",
        "country": "Turkey",
        "zip_code": "34732"
    },
    "shipping_address": {
        "contact_name": "Jane Doe",
        "city": "Istanbul",
        "country": "Turkey",
        "address": "Address",
        "zip_code": "34732"
    },
    "billing_address": {
        "contact_name": "Jane Doe",
        "city": "Istanbul",
        "country": "Turkey",
        "address": "Address",
        "zip_code": "34732"
    },
    "basket_items": [
        {
            "id": "item-1",
            "name": "Product Name",
            "category1": "Category",
            "category2": "Subcategory",
            "price": "100.00"
        }
    ]
}
```

**Başarılı Yanıt:**
```json
{
    "success": true,
    "redirect_url": "3D Secure HTML content",
    "payment_id": "payment-id",
    "conversation_id": "conversation-id"
}
```

### 2. Mobil Entegrasyon

1. API'ye ödeme isteği gönderin
2. Dönen `redirect_url`'i WebView'da açın
3. Kullanıcı 3D Secure doğrulamasını tamamladıktan sonra callback URL'e yönlendirilir
4. Başarılı işlemler için success URL'den sonuç alın

### 3. Test Kart Numaraları

- **Başarılı Test:** 5528790000000008
- **Başarısız Test:** 5528790000000004

## Dosya Yapısı

```
├── api/
│   ├── payment.php          # Ödeme başlatma API'si
│   └── callback.php         # 3D Secure callback handler
├── config/
│   └── iyzico.php          # Iyzico konfigürasyonu
├── pages/
│   ├── success.php         # Başarılı ödeme sayfası
│   └── failure.php         # Başarısız ödeme sayfası
├── src/
│   └── IyzicoService.php   # Ana Iyzico servis sınıfı
├── examples/
│   └── payment_request.php # Örnek kullanım
├── composer.json
├── .env.example
└── README.md
```

## Güvenlik Notları

- API anahtarlarını `.env` dosyasında saklayın
- Production ortamında `https://api.iyzipay.com` kullanın
- Callback URL'lerini güvenli hale getirin
- Ödeme verilerini loglamayı unutmayın

## Hata Kodları

- `INVALID_JSON_DATA`: Geçersiz JSON verisi
- `MISSING_REQUIRED_FIELD`: Gerekli alan eksik
- `CALLBACK_ERROR`: Callback işlemi hatası
- `UNKNOWN_ERROR`: Bilinmeyen hata
