<?php

// Load .env file
$envFile = __DIR__ . '/../.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) {
            continue;
        }
        
        list($name, $value) = explode('=', $line, 2);
        $name = trim($name);
        $value = trim($value);
        
        if (!array_key_exists($name, $_SERVER) && !array_key_exists($name, $_ENV)) {
            putenv(sprintf('%s=%s', $name, $value));
            $_ENV[$name] = $value;
            $_SERVER[$name] = $value;
        }
    }
}

return [
    'api_key' => $_ENV['IYZICO_API_KEY'] ?? 'your-api-key',
    'secret_key' => $_ENV['IYZICO_SECRET_KEY'] ?? 'your-secret-key',
    'base_url' => $_ENV['IYZICO_BASE_URL'] ?? 'https://sandbox-api.iyzipay.com',
    'callback_url' => $_ENV['IYZICO_CALLBACK_URL'] ?? 'https://yourdomain.com/payment/callback',
    'success_url' => $_ENV['IYZICO_SUCCESS_URL'] ?? 'https://yourdomain.com/payment/success',
    'failure_url' => $_ENV['IYZICO_FAILURE_URL'] ?? 'https://yourdomain.com/payment/failure'
];
