<?php

// Example of how to make a payment request to your API

$paymentData = [
    'conversation_id' => 'unique-conversation-id-' . time(),
    'price' => '100.00',
    'paid_price' => '100.00',
    'basket_id' => 'basket-' . time(),
    
    // Card information
    'card' => [
        'holder_name' => 'John Doe',
        'number' => '5528790000000008', // Test card number
        'expire_month' => '12',
        'expire_year' => '2030',
        'cvc' => '123'
    ],
    
    // Buyer information
    'buyer' => [
        'id' => 'buyer-123',
        'name' => 'John',
        'surname' => 'Doe',
        'gsm_number' => '+905350000000',
        'email' => 'email@email.com',
        'identity_number' => '74300864791',
        'last_login_date' => '2023-03-05 12:43:35',
        'registration_date' => '2013-04-21 15:12:09',
        'registration_address' => 'Nidakule Göztepe, Merdivenköy Mah. Bora Sok. No:1',
        'ip' => '85.34.78.112',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'zip_code' => '34732'
    ],
    
    // Shipping address
    'shipping_address' => [
        'contact_name' => 'Jane Doe',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'address' => 'Nidakule Göztepe, Merdivenköy Mah. Bora Sok. No:1',
        'zip_code' => '34732'
    ],
    
    // Billing address
    'billing_address' => [
        'contact_name' => 'Jane Doe',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'address' => 'Nidakule Göztepe, Merdivenköy Mah. Bora Sok. No:1',
        'zip_code' => '34732'
    ],
    
    // Basket items
    'basket_items' => [
        [
            'id' => 'item-1',
            'name' => 'Binocular',
            'category1' => 'Collectibles',
            'category2' => 'Accessories',
            'price' => '100.00'
        ]
    ]
];

// Make API request
$url = 'http://yourdomain.com/api/payment.php';
$options = [
    'http' => [
        'header' => "Content-type: application/json\r\n",
        'method' => 'POST',
        'content' => json_encode($paymentData)
    ]
];

$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);
$response = json_decode($result, true);

if ($response['success']) {
    echo "3D Secure URL: " . $response['redirect_url'] . "\n";
    echo "Payment ID: " . $response['payment_id'] . "\n";
    echo "Conversation ID: " . $response['conversation_id'] . "\n";
} else {
    echo "Error: " . $response['error'] . "\n";
    echo "Error Code: " . $response['error_code'] . "\n";
}
