<?php

header('Content-Type: application/json');

$paymentId = $_GET['payment_id'] ?? null;
$status = $_GET['status'] ?? null;
$conversationId = $_GET['conversation_id'] ?? null;

if ($paymentId && $status === 'success') {
    // Log successful payment completion
    error_log("Payment completed successfully - Payment ID: {$paymentId}, Conversation ID: {$conversationId}");
    
    // Return success response for mobile app
    echo json_encode([
        'success' => true,
        'message' => 'Ödeme başarıyla tamamlandı',
        'payment_id' => $paymentId,
        'conversation_id' => $conversationId,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
} else {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Geçersiz ödeme bilgileri',
        'error' => 'INVALID_PAYMENT_DATA'
    ]);
}
