<?php

// Simple API connection test
require_once __DIR__ . '/vendor/autoload.php';

use Iyzipay\Options;
use Iyzipay\Model\CheckoutFormInitialize;
use Iyzipay\Request\CreateCheckoutFormInitializeRequest;

echo "=== Simple Iyzico API Test ===\n\n";

try {
    // Load config
    $config = require __DIR__ . '/config/iyzico.php';
    
    echo "1. API Bilgileri:\n";
    echo "   API Key: " . substr($config['api_key'], 0, 8) . "...\n";
    echo "   Base URL: " . $config['base_url'] . "\n\n";
    
    // Initialize options
    $options = new Options();
    $options->setApiKey($config['api_key']);
    $options->setSecretKey($config['secret_key']);
    $options->setBaseUrl($config['base_url']);
    
    echo "2. Basit checkout form testi...\n";
    
    // Simple checkout form request
    $request = new CreateCheckoutFormInitializeRequest();
    $request->setLocale(\Iyzipay\Model\Locale::TR);
    $request->setConversationId('test-' . time());
    $request->setPrice('1.0');
    $request->setPaidPrice('1.0');
    $request->setCurrency(\Iyzipay\Model\Currency::TL);
    $request->setBasketId('test-basket');
    $request->setPaymentGroup(\Iyzipay\Model\PaymentGroup::PRODUCT);
    $request->setCallbackUrl('https://www.merchant.com/callback');
    
    // Add buyer
    $buyer = new \Iyzipay\Model\Buyer();
    $buyer->setId('test-buyer');
    $buyer->setName('Test');
    $buyer->setSurname('User');
    $buyer->setGsmNumber('+905350000000');
    $buyer->setEmail('test@test.com');
    $buyer->setIdentityNumber('74300864791');
    $buyer->setLastLoginDate('2023-03-05 12:43:35');
    $buyer->setRegistrationDate('2013-04-21 15:12:09');
    $buyer->setRegistrationAddress('Test Address');
    $buyer->setIp('127.0.0.1');
    $buyer->setCity('Istanbul');
    $buyer->setCountry('Turkey');
    $buyer->setZipCode('34732');
    $request->setBuyer($buyer);
    
    // Add addresses
    $shippingAddress = new \Iyzipay\Model\Address();
    $shippingAddress->setContactName('Test User');
    $shippingAddress->setCity('Istanbul');
    $shippingAddress->setCountry('Turkey');
    $shippingAddress->setAddress('Test Address');
    $shippingAddress->setZipCode('34732');
    $request->setShippingAddress($shippingAddress);
    $request->setBillingAddress($shippingAddress);
    
    // Add basket item
    $basketItem = new \Iyzipay\Model\BasketItem();
    $basketItem->setId('test-item');
    $basketItem->setName('Test Product');
    $basketItem->setCategory1('Test');
    $basketItem->setItemType(\Iyzipay\Model\BasketItemType::PHYSICAL);
    $basketItem->setPrice('1.0');
    $request->setBasketItems([$basketItem]);
    
    echo "3. API çağrısı yapılıyor...\n";
    
    $checkoutFormInitialize = CheckoutFormInitialize::create($request, $options);
    
    echo "4. Sonuç:\n";
    echo "   Status: " . $checkoutFormInitialize->getStatus() . "\n";
    
    if ($checkoutFormInitialize->getStatus() == 'success') {
        echo "✓ API bağlantısı başarılı!\n";
        echo "   Checkout Form URL mevcut\n";
        echo "   Payment ID: " . $checkoutFormInitialize->getPaymentId() . "\n";
    } else {
        echo "✗ API hatası:\n";
        echo "   Error: " . $checkoutFormInitialize->getErrorMessage() . "\n";
        echo "   Error Code: " . $checkoutFormInitialize->getErrorCode() . "\n";
    }
    
} catch (Exception $e) {
    echo "✗ Exception: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
}

echo "\n=== Test Tamamlandı ===\n";
