#!/bin/bash

# Test cURL for Iyzico Payment API
# Replace localhost:8000 with your actual domain

echo "=== Iyzico Payment API Test with cURL ==="
echo

# Generate timestamps
TIMESTAMP=$(date +%s)
LAST_LOGIN=$(date -v-1H '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date -d '1 hour ago' '+%Y-%m-%d %H:%M:%S')
REG_DATE=$(date -v-1y '+%Y-%m-%d %H:%M:%S' 2>/dev/null || date -d '1 year ago' '+%Y-%m-%d %H:%M:%S')

# Payment data with your card details
curl -X POST http://localhost:8000/api/payment.php \
  -H "Content-Type: application/json" \
  -d "{
    \"conversation_id\": \"test-conv-${TIMESTAMP}\",
    \"price\": \"10.00\",
    \"paid_price\": \"10.00\",
    \"basket_id\": \"test-basket-${TIMESTAMP}\",
    \"card\": {
      \"holder_name\": \"Test User\",
      \"number\": \"6587619825149656\",
      \"expire_month\": \"12\",
      \"expire_year\": \"2025\",
      \"cvc\": \"152\"
    },
    \"buyer\": {
      \"id\": \"test-buyer-${TIMESTAMP}\",
      \"name\": \"Test\",
      \"surname\": \"User\",
      \"gsm_number\": \"+905350000000\",
      \"email\": \"test@example.com\",
      \"identity_number\": \"74300864791\",
      \"last_login_date\": \"${LAST_LOGIN}\",
      \"registration_date\": \"${REG_DATE}\",
      \"registration_address\": \"Test Address Istanbul\",
      \"ip\": \"127.0.0.1\",
      \"city\": \"Istanbul\",
      \"country\": \"Turkey\",
      \"zip_code\": \"34000\"
    },
    \"shipping_address\": {
      \"contact_name\": \"Test User\",
      \"city\": \"Istanbul\",
      \"country\": \"Turkey\",
      \"address\": \"Test Shipping Address\",
      \"zip_code\": \"34000\"
    },
    \"billing_address\": {
      \"contact_name\": \"Test User\",
      \"city\": \"Istanbul\",
      \"country\": \"Turkey\",
      \"address\": \"Test Billing Address\",
      \"zip_code\": \"34000\"
    },
    \"basket_items\": [
      {
        \"id\": \"test-item-1\",
        \"name\": \"Test Ürün\",
        \"category1\": \"Test Kategori\",
        \"category2\": \"Alt Kategori\",
        \"price\": \"10.00\"
      }
    ]
  }"

echo
echo "=== Test Tamamlandı ==="
