<?php

// Simple test script to demonstrate the payment flow
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/src/IyzicoService.php';

use IyzicoIntegration\IyzicoService;

echo "=== Iyzico 3D Secure Payment Test ===\n\n";

// Test payment data
$paymentData = [
    'conversation_id' => 'test-conv-' . time(),
    'price' => '1.00',
    'paid_price' => '1.00',
    'basket_id' => 'test-basket-' . time(),
    
    'card' => [
        'holder_name' => 'John Doe',
        'number' => '5528790000000008', // Test card
        'expire_month' => '12',
        'expire_year' => '2030',
        'cvc' => '123'
    ],
    
    'buyer' => [
        'id' => 'test-buyer-123',
        'name' => 'John',
        'surname' => 'Doe',
        'gsm_number' => '+905350000000',
        'email' => 'test@email.com',
        'identity_number' => '74300864791',
        'last_login_date' => '2023-03-05 12:43:35',
        'registration_date' => '2013-04-21 15:12:09',
        'registration_address' => 'Test Address',
        'ip' => '127.0.0.1',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'zip_code' => '34732'
    ],
    
    'shipping_address' => [
        'contact_name' => 'John Doe',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'address' => 'Test Shipping Address',
        'zip_code' => '34732'
    ],
    
    'billing_address' => [
        'contact_name' => 'John Doe',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'address' => 'Test Billing Address',
        'zip_code' => '34732'
    ],
    
    'basket_items' => [
        [
            'id' => 'test-item-1',
            'name' => 'Test Product',
            'category1' => 'Test Category',
            'category2' => 'Test Subcategory',
            'price' => '1.00'
        ]
    ]
];

try {
    $iyzicoService = new IyzicoService();
    
    echo "1. Validating payment data...\n";
    $validation = $iyzicoService->validatePaymentData($paymentData);
    
    if ($validation['valid']) {
        echo "✓ Payment data is valid\n\n";
        
        echo "2. Initializing 3D Secure payment...\n";
        echo "Note: This will fail without valid API credentials\n";
        echo "Please update your .env file with real Iyzico credentials\n\n";
        
        // Uncomment the following lines when you have valid API credentials:
        /*
        $result = $iyzicoService->initializeThreedsPayment($paymentData);
        
        if ($result['success']) {
            echo "✓ 3D Secure initialization successful!\n";
            echo "Payment ID: " . $result['payment_id'] . "\n";
            echo "Conversation ID: " . $result['conversation_id'] . "\n";
            echo "Redirect URL length: " . strlen($result['redirect_url']) . " characters\n";
        } else {
            echo "✗ 3D Secure initialization failed:\n";
            echo "Error: " . $result['error'] . "\n";
            echo "Error Code: " . $result['error_code'] . "\n";
        }
        */
        
    } else {
        echo "✗ Payment data validation failed: " . $validation['error'] . "\n";
    }
    
} catch (Exception $e) {
    echo "✗ Exception occurred: " . $e->getMessage() . "\n";
}

echo "\n=== Test Complete ===\n";
echo "\nNext steps:\n";
echo "1. Copy .env.example to .env\n";
echo "2. Update .env with your Iyzico API credentials\n";
echo "3. Update callback URLs to match your domain\n";
echo "4. Test with the API endpoints\n";
