<?php

// Test with user's specific card details
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/src/IyzicoService.php';

use IyzicoIntegration\IyzicoService;

echo "=== Iyzico Payment Test - User Card ===\n\n";

// Test payment data with user's card
$paymentData = [
    'conversation_id' => 'test-conv-' . time(),
    'price' => '10.00',
    'paid_price' => '10.00',
    'basket_id' => 'test-basket-' . time(),
    
    'card' => [
        'holder_name' => 'Test User',
        'number' => '6587619825149656', // User's test card
        'expire_month' => '12',
        'expire_year' => '2025',
        'cvc' => '152'
    ],
    
    'buyer' => [
        'id' => 'test-buyer-' . time(),
        'name' => 'Test',
        'surname' => 'User',
        'gsm_number' => '+905350000000',
        'email' => 'test@example.com',
        'identity_number' => '74300864791',
        'last_login_date' => date('Y-m-d H:i:s', strtotime('-1 hour')),
        'registration_date' => date('Y-m-d H:i:s', strtotime('-1 year')),
        'registration_address' => 'Test Address Istanbul',
        'ip' => '127.0.0.1',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'zip_code' => '34000'
    ],
    
    'shipping_address' => [
        'contact_name' => 'Test User',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'address' => 'Test Shipping Address, Istanbul',
        'zip_code' => '34000'
    ],
    
    'billing_address' => [
        'contact_name' => 'Test User',
        'city' => 'Istanbul',
        'country' => 'Turkey',
        'address' => 'Test Billing Address, Istanbul',
        'zip_code' => '34000'
    ],
    
    'basket_items' => [
        [
            'id' => 'test-product-1',
            'name' => 'Test Ürün',
            'category1' => 'Test Kategori',
            'category2' => 'Alt Kategori',
            'price' => '10.00'
        ]
    ]
];

try {
    $iyzicoService = new IyzicoService();
    
    echo "1. Kart bilgileri:\n";
    echo "   Kart No: " . substr($paymentData['card']['number'], 0, 4) . "****" . substr($paymentData['card']['number'], -4) . "\n";
    echo "   Son Kullanma: " . $paymentData['card']['expire_month'] . "/" . $paymentData['card']['expire_year'] . "\n";
    echo "   CVC: " . $paymentData['card']['cvc'] . "\n\n";
    
    echo "2. Ödeme verilerini doğrulama...\n";
    $validation = $iyzicoService->validatePaymentData($paymentData);
    
    if ($validation['valid']) {
        echo "✓ Ödeme verileri geçerli\n\n";
        
        echo "3. 3D Secure ödeme başlatılıyor...\n";
        $result = $iyzicoService->initializeThreedsPayment($paymentData);
        
        if ($result['success']) {
            echo "✓ 3D Secure başlatma başarılı!\n";
            echo "Payment ID: " . $result['payment_id'] . "\n";
            echo "Conversation ID: " . $result['conversation_id'] . "\n";
            echo "3D Secure HTML uzunluğu: " . strlen($result['redirect_url']) . " karakter\n\n";
            
            // Save HTML content to file for inspection
            file_put_contents(__DIR__ . '/3d_secure_form.html', $result['redirect_url']);
            echo "✓ 3D Secure formu '3d_secure_form.html' dosyasına kaydedildi\n";
            echo "Bu dosyayı tarayıcıda açarak 3D Secure formunu görebilirsiniz\n\n";
            
            echo "Mobil entegrasyon için:\n";
            echo "- Bu HTML içeriğini WebView'da gösterin\n";
            echo "- Kullanıcı doğrulama yaptıktan sonra callback URL'e yönlendirilecek\n";
            echo "- Callback: " . (require __DIR__ . '/config/iyzico.php')['callback_url'] . "\n";
            
        } else {
            echo "✗ 3D Secure başlatma başarısız:\n";
            echo "Hata: " . $result['error'] . "\n";
            echo "Hata Kodu: " . $result['error_code'] . "\n";
        }
        
    } else {
        echo "✗ Ödeme verisi doğrulama hatası: " . $validation['error'] . "\n";
    }
    
} catch (Exception $e) {
    echo "✗ Hata oluştu: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n=== Test Tamamlandı ===\n";
